<?php

namespace App\Http\Controllers;

use App\Models\Candidatura;
use App\Models\Cliente;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class CandidaturasClienteController extends Controller
{
    public function index(Request $request){
        $usuario = Auth::user();
        $cliente = Cliente::where('email_cliente', $usuario->email_acesso)->first();
        $search = $request->input('search');
     
        $candidaturas = Candidatura::query()->when($search, function ($query, $search) {
            $query->Where('numero_registro', 'LIKE', "%{$search}%");
        });

        $candidaturas = $cliente->candidatura;
        return view('dashboard.client.pages.candidaturas.candidaturas', ['candidaturas'=> $candidaturas]);
    }


    public function destroy(string $id){
        $candidatura = Candidatura::find($id);

        if($candidatura){
            $candidatura->delete();

            return redirect()->back()->with([
                'toast_message'=> 'Candidatura cancelada',
                'toast_type' => 'success'
            ]);
        }
    }
}
