<?php

namespace App\Http\Controllers;

use App\Models\Cliente;
use Illuminate\Http\Request;

class ClientesController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $search = $request->input('search');

     
        $clientes = Cliente::query()->when($search, function ($query, $search) {
            $query->Where('nome_cliente', '=', "%{$search}%")
            ->orWhere('email_cliente', '=', "%{$search}%");
        })->paginate(10);

        return view('dashboard.admin.pages.clientes.clientes', ['clientes'=> $clientes]);
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
