<?php

namespace App\Http\Controllers;

use App\Models\Noticia;
use App\Models\Tipo_noticia;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class NoticiasController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $search = trim($request->input('search', ''));

        $noticias = Noticia::query()->when($search, function ($query, $search) {
            $query->Where('titulo_noticia', 'LIKE', "%{$search}%");
        })->paginate(10)
        ->appends(['search' => $search]);

        $tipo_noticias = Tipo_noticia::all();

        return view('dashboard.admin.pages.noticias.noticias',
        [
            'noticias'=> $noticias,
            'tipo_noticias' => $tipo_noticias
        ]);
    }

    /**
     * Show the form for creating a new resource.
     */
    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'titulo_noticia' => 'required|string|max:255',
            'descricao_noticia' => 'required',
            'tipo_noticia_id' => 'required',
            'autor_noticia'=> 'required',
            'path_imagem' => 'nullable|image|mimes:jpeg,png,jpg,gif,webp|max:2048',

            ],
            [
                'titulo_noticia.required' => 'O titulo da noticia é obrigatório.',
                'titulo_noticia.max' => 'O titulo da noticia excedeu o limite de 255 caracteres, por favor reduza.',
                'descricao_noticia.required' => 'A descrição é obrigatória.',

                'tipo_noticia_id.required'=>'Selecione o tipo da noticia',

                'autor_noticia.required'=>'O autor é obrigatório',

                'paht_imagem.image' => 'O arquivo deve ser uma imagem.',
                'paht_imagem.mimes' => 'A imagem deve estar no formato: jpeg, png, jpg, gif ou webp.',
                'paht_imagem.max'   => 'A imagem não pode ter mais que 2MB.',
            ]
        );

        if ($validator->fails()) {
            return redirect()->back()
                ->withInput()
                ->with([
                    'toast_message' => $validator->errors()->first(),
                    'toast_type' => 'error'
                ]);

        }

        $dados = $request->only([
            'titulo_noticia', 'descricao_noticia',
            'tipo_noticia_id', 'autor_noticia'
        ]);


        $dados['path_imagem'] = null;
        $destaque = $request->filled('destaque') ? 1 : 0;

        if ($request->hasFile('path_imagem')) {


            $path = $request->file('path_imagem')->store('noticias', 'public');

            $dados['path_imagem'] = $path;

        }

        $noticia = Noticia::create([
            'titulo_noticia' => $dados['titulo_noticia'],
            'descricao' => $dados['descricao_noticia'],
            'tipo_noticia_id'=> $dados['tipo_noticia_id'],
            'autor_noticia'=> $dados['autor_noticia'],
            'path_imagem' => $dados['path_imagem'],
            'destaque' => $destaque
        ]);

        return redirect()->back()->with([
            'toast_message' => 'Noticia adicionada com sucesso!',
            'toast_type' => 'success'
        ]);
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
