<?php

namespace App\Http\Controllers;

use App\Models\Cliente;
use App\Models\Obra;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ObrasClienteController extends Controller
{
     public function index(Request $request){
        $usuario = Auth::user();
        $cliente = Cliente::where('email_cliente', $usuario->email_acesso)->first();
        $search = $request->input('search');

        $obras = Obra::query()->when($search, function ($query, $search) {
            $query->Where('ref_obra', 'LIKE', "%{$search}%");
        });

        $obras = $cliente->obra;
        return view('dashboard.client.pages.projectos.projectos', ['obras'=> $obras]);
    }
}
