<?php

namespace App\Http\Controllers;

use App\Models\Obra;
use App\Models\Relatorios_obra;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class RelatorioObraController extends Controller
{

    public function indexForClient(){

    }
    public function storeFiles(Request $request, string $id){
        $validator = Validator::make($request->all(), [
                'docs.*'    => 'file|mimes:pdf,doc,docx|max:5120',      // max 5MB
                'galeria.*' => 'image|mimes:jpeg,png,jpg,gif,webp|max:5120',
            ],
            [
                'nome_completo.required' => 'O nome  é obrigatório.',

                'email_acesso.required' => 'O email é obrigatório.',
                'email_acesso.email'=>'Por favor, insira um e-mail válido: exemplo@gmial.com',
                'email_acesso.unique'=> 'Já existe uma conta associada a este e-mail',

                'passoword.required' => 'A palavra-chave é obrigatório',
                'password.required' => 'A palvra-chave tem que ter no mínimo 6 caracteres',

                'painel' => 'Selecione um painel de redirecionamento',
            ]
        );

        if ($validator->fails()) {
            return redirect()->back()
                ->withInput()
                ->with([
                    'toast_message' => $validator->errors()->first(),
                    'toast_type' => 'error'
                ]);

        }


        $obra = Obra::findOrFail($id);


        if ($request->hasFile('docs')) {
            $this->uploadFiles($request->file('docs'), $obra, 'relatorios/docs');
        }

        if ($request->hasFile('galeria')) {
            $this->uploadFiles($request->file('galeria'), $obra, 'relatorios/image');
        }

        return redirect()->back()->with([
            'toast_message'=> 'Arquivo adicionado!',
            'toast_type'=> 'success'
        ]);



    }

    private function uploadFiles(array $files, Obra $obra, string $folder)
    {
        foreach ($files as $file) {
            if (!$file->isValid()) continue;

            $path = $file->store($folder, 'public');

            Relatorios_obra::create([
                'path'     => $path,
                'obra_id'  => $obra->obra_id,
            ]);
        }
    }
}
