<?php

namespace App\Http\Controllers;

use App\Models\Usuario;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;

class UsuariosController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $user = Auth::user();
        
        $search = $request->input('search');
     
        $usuarios = Usuario::query()->when($search, function ($query, $search) {
            $query->Where('email_acesso', 'LIKE', "%{$search}%");
        })->where('email_acesso', '!=', $user->email_acesso)->paginate(10);
    
      
        return view('dashboard.admin.pages.usuarios.usuarios', ['usuarios'=> $usuarios]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'nome_completo' => 'required',
            'email_acesso' => 'required|email|unique:usuarios,email_acesso',
            'password' => 'required|min:6',
            'painel'=> 'required',
            ],
            [
                'nome_completo.required' => 'O nome  é obrigatório.',
                
                'email_acesso.required' => 'O email é obrigatório.',
                'email_acesso.email'=>'Por favor, insira um e-mail válido: exemplo@gmial.com',
                'email_acesso.unique'=> 'Já existe uma conta associada a este e-mail',
                
                'passoword.required' => 'A palavra-chave é obrigatório',
                'password.required' => 'A palvra-chave tem que ter no mínimo 6 caracteres',

                'painel' => 'Selecione um painel de redirecionamento',
            ]
        );

        if ($validator->fails()) {
            return redirect()->back()
                ->withInput()
                ->with([
                    'toast_message' => $validator->errors()->first(),
                    'toast_type' => 'error'
                ]);
        
        }

        DB::transaction(function() use($request){
            $usuario = Usuario::create([
                'email_acesso' => $request->email_acesso,
                'password'=> $request->password,
                'status' => true,
                'painel' => $request->painel
            ]);

            $usuario->funcionario()->create([
                'nome_funcionario'=> $request->nome_completo,
                'cargo'=> $request->painel
            ]);
        });

        return redirect()->back()->with([
            'toast_message'=> 'Usuário adicionado com sucesso!',
            'toast_type'=> 'success'
        ]);
    }

    public function update(Request $request, string $id){
        $usuario = Usuario::find($id);

        if($usuario){
            $usuario->update([
                'status' => $request->status
            ]);

            return redirect()->back()->with([
                'toast_message' => 'Usuário actualizado',
                'toast_type' => 'success'
            ]);
        }
    }
    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        $usuario = Usuario::find($id);

        if($usuario){
            $usuario->delete();

            return redirect()->back()->with([
                'toast_message'=> 'Usuário eliminado com sucesso!',
                'toast_type'=> 'success'
            ]);
        }
    }
}
