<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Anexo extends Model
{
    public $timestamps = false;

    protected $primaryKey = 'anexo_id';
    
    use HasFactory;

    protected $fillable = [
        'doc_anexo',
        'candidatura_id'
    ];

    

    
    public function candidatura(): BelongsTo
    {
        return $this->belongsTo(Candidatura::class, 'candidatura_id', 'candidatura_id');
    }
}
