<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Candidatura extends Model
{
    const CREATED_AT = 'data_candidatura';
    const UPDATED_AT = null;

    protected $primaryKey = 'candidatura_id';

    use HasFactory;

    protected $fillable = [
        'cliente_id',
        'nome_candidato',
        'email_candidato',
        'bilhete_candidato',
        'telefone_candidato',
        'numero_registro',
        'status',
        'vaga_id',
        'descricao_candidatura',
        'data_candidatura'
    ];

    public function cliente(): BelongsTo
    {
        return $this->belongsTo(Cliente::class, 'cliente_id', 'cliente_id');
    }

    public function anexo(): HasMany
    {
        return $this->hasMany(Anexo::class, 'candidatura_id');
    }

    public function vaga(): BelongsTo
    {
        return $this->belongsTo(Vaga::class, 'vaga_id', 'vaga_id');
    }


}
