<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Obra extends Model
{
    const CREATED_AT = 'data_registro';
    const UPDATED_AT = null;

    protected $primaryKey = 'obra_id';

    use HasFactory;

    protected $fillable = [
        'nome_obra',
        'ref_obra',
        'cliente_id',
        'orcamento',
        'custo_total',
        'moeda',
        'tipo_servico',
        'tipo_projecto',
        'data_inicio',
        'data_projecto'
    ];

    public function cliente():BelongsTo{
        return $this->belongsTo(Cliente::class, 'cliente_id', 'cliente_id');
    }

     public function relatorio(): HasMany{
        return $this->hasMany(Relatorios_obra::class, 'cliente_id');
    }
}
