<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Projecto extends Model
{
    public $timestamps = false;

    use HasFactory;

    protected $primaryKey =  'projecto_id';
    protected $fillable = [
        'nome_projecto',
        'referencia_projecto',
        'endereco',
        'nome_cliente',
        'engenheiro_resp',
        'orcamento_prev',
        'custo_total',
        'moeda',
        'estado',
        'tipo_servico',
        'tipo_projecto',
        'descricao_projecto',
        'imagem_projecto',
        'data_projecto'
    ];

    public function galeria()
    {
        return $this->morphMany(Galeria::class, 'galeria_de');
    }
}
