<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Relatorios_obra extends Model
{
    const CREATED_AT = 'data_registro';
    const UPDATED_AT = 'actualizado_em';
    protected $primaryKey = 'relatorio_obra_id';

    use HasFactory;

    protected $fillable = [
        'path',
        'obra_id',
        'data_registro',
        'actualizado_em'
    ];

    public function obra():BelongsTo{
        return $this->belongsTo(Obra::class, 'obra_id', 'obra_id');
    }
}
