<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Vaga extends Model
{
    public $timestamps = false;

    protected $primaryKey = 'vaga_id';

    use HasFactory;

    protected $fillable = [
        'nome_vaga',
        'descricao_vaga',
        'numero_vaga',
        'imagem_vaga',
        'data_inicio',
        'data_fim'
    ];


    public function candidatura(): HasMany
    {
        return $this->hasMany(Candidatura::class, 'candidatura_id');
    } 
}
