<div class="row mb-6 gy-6">
                <div class="col-xl">
                  <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center">
                      @if (request()->routeIs('obras.create'))
                          <h5 class="mb-0">Cadastrar Obras</h5>
                      @else
                          <h5 class="mb-0">Editar Obra</h5>
                      @endif
                      <small class="text-body float-end">Formulário de preenchimento</small>
                    </div>
                    <div class="card-body row">
                        <div class="mb-6 col-md-6">
                          <label class="form-label" for="nome_obra">Nome da obra</label>
                          <div class="input-group input-group-merge">
                            <span class="input-group-text"
                              ><i class="icon-base bx bx-user"></i
                            ></span>
                            <input
                              type="text"
                              class="form-control"
                              id="nome_obra"
                              name="nome_obra"
                              value="{{  old('nome_obra', $obra->nome_obra ?? '') }}"
                              />
                          </div>
                        </div>
                        <div class="mb-6 col-md-3 col-6">
                          <label class="form-label" for="ref_obra">Referência</label>
                          <div class="input-group input-group-merge">
                            <span class="input-group-text"
                              ><i class="icon-base bx bx-user"></i
                            ></span>
                            <input
                              type="text"
                              class="form-control"
                              id="ref_obra",
                              name="ref_obra"
                              placeholder="Referência"
                              value="{{ old('ref_obra', $obra->ref_obra ?? '') }}"/>
                          </div>
                        </div>
                        <div class="mb-6 col-md-3 col-6">
                          <label class="form-label" for="data_inicio">Data de inicio</label>
                          <div class="input-group input-group-merge">
                            <span  class="input-group-text"
                              ><i class="icon-base bx bx-calendar-event"></i
                            ></span>
                            <input
                              type="date"
                              class="form-control"
                              id="data_inicio",
                              name="data_inicio",
                              value="{{ old('data_inicio', $obra->data_inicio ?? '') }}"/>
                          </div>
                        </div>

                        <div class="mb-6 col-md-6">
                          <label class="form-label" for="orcamento">Orçamento previsto</label>
                          <div class="input-group input-group-merge">
                            <span class="input-group-text"
                              ><i class="icon-base bx bx-wallet"></i
                            ></span>
                            <input
                              type="number"
                              class="form-control"
                              id="orcamento"
                              name="orcamento"
                              placeholder="Orçamento previsto"
                              aria-label="Orçamento previsto"
                              value="{{ old('orcamento', $obra->orcamento ?? '') }}"
                               />
                          </div>
                        </div>

                        <div class="mb-6 col-md-3 col-6">
                          <label class="form-label" for="custo_total">Custo total</label>
                          <div class="input-group input-group-merge">
                            <span class="input-group-text"
                              ><i class="icon-base bx bx-credit-card"></i
                            ></span>
                            <input
                              type="number"
                              class="form-control"
                              id="custo_total"
                              name="custo_total"
                              placeholder="Custo total"
                              aria-label="Custo total"
                              value="{{ old('custo-total', $obra->custo_total ?? '') }}"
                               />
                          </div>
                        </div>

                        <div class="mb-6 col-md-3 col-6">
                          <label class="form-label" for="moeda">Moeda</label>
                          <div class="input-group input-group-merge">
                            <span class="input-group-text"
                              ><i class="icon-base bx bx-dollar-circle"></i
                            ></span>
                            <select class="form-select" id="moeda" name="moeda">
                              <option  selected disabled>
                                  @if (isset($obra->moeda))
                                      {{ $obra->moeda }}
                                  @else
                                      Escolher
                                  @endif
                              </option>

                              <option value="Kwanza">AOA </option>
                              <option value="Dolar_americano">USD </option>
                              <option value="Euro">EUR </option>
                            </select>
                          </div>
                        </div>

                        <div class="mb-6 col-md-6">
                          <label class="form-label" for="tipo_servico">Tipo de serviço</label>
                          <div class="input-group input-group-merge">
                            <span class="input-group-text"
                              ><i class="icon-base bx bx-tag"></i
                            ></span>
                            <select class="form-select" id="tipo_servico" name="tipo_servico">
                              <option  selected disabled>
                                  @if (isset($obra->tipo_servico))
                                      {{ $obra->tipo_servico }}
                                  @else
                                      Escolher
                                  @endif
                              </option>

                              <option>Design de interior </option>
                              <option>Reforma</option>
                              <option>Obra pública</option>
                              <option>Design de arquitectura</option>
                              <option>Projecto de engenharia</option>


                            </select>
                          </div>
                        </div>

                        <div class="mb-6 col-md-6">
                          <label class="form-label" for="tipo_projecto">Tipo de projecto</label>
                          <div class="input-group input-group-merge">
                            <span  class="input-group-text"
                              ><i class="icon-base bx bx-tag"></i
                            ></span>
                            <select class="form-select" id="tipo_projecto" name="tipo_projecto">
                              <option  selected disabled>
                                  @if (isset($obra->tipo_projecto))
                                      {{ $obra->tipo_projecto }}
                                  @else
                                      Escolher
                                  @endif
                              </option>

                              <option>Residencial</option>
                              <option>Comercial</option>
                              <option>Industrial</option>
                              <option>Infraestrutura Rodoviária</option>

                            </select>
                          </div>
                        </div>

                        <input type="hidden" name="cliente_id" id="cliente_id">

                        <div class="d-flex justify-content-between">
                            <a href="{{ route('obras.index') }}" class="btn border border-dark">Voltar</a>
                            <div class="d-flex gap-2 justify-content-end">
                                @if (request()->routeIs('obras.create'))
                                    <button type="button" class="btn btn-dark" data-bs-toggle="modal" data-bs-target="#modal_vincular_cliente">
                                        Vincular cliente
                                    </button>
                                @else
                                    @if(isset($obra) && is_null($obra->cliente_id))
                                        <button type="button" class="btn btn-dark" data-bs-toggle="modal" data-bs-target="#modal_vincular_cliente">
                                            Vincular cliente
                                        </button>
                                    @endif
                                @endif
                                <button type="submit" class="btn btn-primary" > Salvar</button>
                            </div>
                        </div>
                    </div>
                  </div>
                </div>
</div>
