<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="description" content="VAN THANH – CONSTRUÇÃO CIVIL, (SU), LDA" />
    {{-- <link href="{{ asset('assets/images/ico.png') }}" rel="shortcut icon" type="image/vnd.microsoft.icon" /> --}}


    {{-- bootstrap --}}
    <link rel="stylesheet" href="{{ asset('bootstrap/dist/css/bootstrap.min.css') }}">

    {{-- fonts --}}
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:ital,opsz,wght@0,14..32,100..900;1,14..32,100..900&family=Roboto+Mono:ital,wght@0,100..700;1,100..700&family=Sora:wght@500&display=swap" rel="stylesheet">

   <!-- Boxicons CSS -->
     {{-- box icons --}}
    <link href='https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css' rel='stylesheet'>


    {{-- swiperJs --}}
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@12/swiper-bundle.min.css"/>

    {{-- estilo personalizado --}}
    <link rel="stylesheet" href="{{ asset('assets/css/app.css') }}"/>
    <link rel="stylesheet" href="{{ asset('assets/css/login.css') }}"/>
    <link rel="stylesheet" href="{{ asset('assets/css/app-responsive.css') }}"/>


    <!-- GSAP core -->
    <script src="https://cdn.jsdelivr.net/npm/gsap@3.14.1/dist/gsap.min.js"></script>

    <!-- Plugin ScrollTrigger -->
    <script src="https://cdn.jsdelivr.net/npm/gsap@3.14.1/dist/ScrollTrigger.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.13.0/ScrollSmoother.min.js"></script>

    <title>Van Thanh – Construção Civil  | @yield('title')</title>
</head>
<body>

    <div class="menus">
        @include('components.nav-menu')
    </div>

    <div id="smooth-wrapper">
        <main id="smooth-content">
            @yield('content')
        </main>
    </div>

    @include('components.menu-toggle')

    {{-- Modais --}}
    @stack('modals')



    <!-- Swiper JS -->
    <script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>

    {{-- Bootstrap JS --}}
    <script src="{{ asset('bootstrap/dist/js/bootstrap.bundle.min.js') }}"></script>

    {{-- boxicons --}}
    <script src="https://unpkg.com/boxicons@2.1.3/dist/boxicons.js"></script>

    <script>
        gsap.registerPlugin(ScrollTrigger, ScrollSmoother);

        const smoother = ScrollSmoother.create({
        wrapper: "#smooth-wrapper",
        content: "#smooth-content",
        smooth: 2,
        effects: true
        });

        const menu = document.querySelector('.mainMenu');

        ScrollTrigger.create({
            start: "top -100",
            onEnter: () => menu.classList.add('menu-fixed'),
            onLeaveBack: () => menu.classList.remove('menu-fixed')
        });
    </script>
    @stack('scripts')
</body>

