@extends('layouts.main')

@section('content')


<section class="page-portfolio header">

    <div class="hero-section d-flex">
            <div class="text-desc ">
                <h1 class="fw-bold">Garantimos qualidade e segurança em nossos projectos</h1>
                <p class="small my-4 text-muted">Lorem ipsum dolor sit amet consectetur, adipisicing elit. Dolorum quos, vero minima fugiat a numquam rerum cum odio aperiam repudiandae distinctio? Quae quaerat cupiditate ipsa excepturi temporibus obcaecati tempore eveniet.</p>
            </div>

           <div class="hero-img ">
                <img src="{{ asset('assets/img/background11.jpg') }}" alt="image-2" width="200">
           </div>
    </div>
</section>

<section class="projects d-flex justify-content-between">
    <form method="GET" action="{{ route('portfolio') }}" class="filters-menu shadow">

        <p class="my-2 fw-bold">Filtros</p>
        <hr>

        {{-- Tipo de serviço --}}
        <div class="item">
            <p class="my-2 fw-bold">Tipo de serviço</p>
            <ul class="list-unstyled text-muted">

                @php
                    $servicos = [
                        'construcao' => 'Construção',
                        'obras_publicas' => 'Obras públicas',
                        'reforma' => 'Reformas',
                        'projecto_engenharia' => 'Projectos de engenharia',
                        'design_arquitectura' => 'Design de arquitectura',
                        'design_interior' => 'Design de interior'
                    ];
                @endphp

                @foreach ($servicos as $slug => $label)
                    <li>
                        <input
                            type="checkbox"
                            name="servico[]"
                            value="{{ $slug }}"
                            id="servico_{{ $slug }}"
                            {{ in_array($slug, request('servico', [])) ? 'checked' : '' }}
                        >
                        <label for="servico_{{ $slug }}">{{ $label }}</label>
                    </li>
                @endforeach

            </ul>
        </div>

        {{-- Tipo de projecto --}}
        <div class="item">
            <p class="my-2 fw-bold">Tipo de projecto</p>
            <ul class="list-unstyled text-muted">

                @php
                    $tipos = [
                        'residencial' => 'Residencial',
                        'comercial' => 'Comercial',
                        'industrial' => 'Industrial',
                    ];
                @endphp

                @foreach ($tipos as $slug => $label)
                    <li>
                        <input
                            type="checkbox"
                            name="projecto[]"
                            value="{{ $label }}"
                            id="projecto_{{ $slug }}"
                            {{ in_array($slug, request('projecto', [])) ? 'checked' : '' }}
                        >
                        <label for="projecto_{{ $slug }}">{{ $label }}</label>
                    </li>
                @endforeach

            </ul>

            <button class="btn btn-dark w-100" style="font-size: 14px">
                Filtrar
            </button>
        </div>

    </form>

    <div class="projects-content">
        <div class="search">
            <input type="search" name="" id="" placeholder="Pesquisar alguma coisa">
        </div>

        <div class="card-projects">
            @foreach ($projectos as $projecto )
                  <div class="card-projects-item shadow-sm">
                    <div class="image"><img src="{{ asset('storage/' .$projecto->imagem_projecto) }}" width="80" height="80" alt="{{ $projecto->nome_projecto }}"></div>
                    <div class="desc">
                        <p class="fw-bold m-0">{{ $projecto->nome_projecto }}</p>
                        <span class="small text-muted"><i class="bx bx-map"></i> {{ $projecto->endereco }}</span>
                        <hr>
                        <a class="btn btn-dark" href="{{ route('project-details', $projecto->projecto_id) }}" style="font-size:14px"> ver mais</a>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</section>

@include('components.footer')

@endsection

