<?php

use App\Http\Controllers\AppController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\BackupController;
use App\Http\Controllers\CandidaturasClienteController;
use App\Http\Controllers\CandidaturasController;
use App\Http\Controllers\ClientesController;
use App\Http\Controllers\PerfilController;
use App\Http\Controllers\RestauroController;
use App\Http\Controllers\VagasController;
use App\Http\Controllers\ProjectosController;
use App\Http\Controllers\NoticiasController;
use App\Http\Controllers\UsuariosController;
use App\Http\Controllers\ObrasController;
use App\Http\Controllers\ObrasClienteController;
use App\Http\Controllers\RelatorioObraController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('', [AppController::class, 'index'])->name('index');
Route::get('/sobre-nos', [AppController::class, 'about'])->name('about');
Route::get('/noticias', [AppController::class, 'blog'])->name('blog');
Route::get('/trabalhe-conosco', [AppController::class, 'work'])->name('work-us');
Route::get('portfolio', [AppController::class, 'portfolio'])->name('portfolio');
Route::get('detalhes-da-noticia/{id}', [AppController::class, 'news_details'])->name('news-details');
Route::get('detalhes-do-projecto/{id}', [AppController::class, 'project_details'])->name('project-details');
Route::get('entrar', [AppController::class, 'login'])->name('login');
Route::get('criar-conta', [AppController::class, 'register'])->name('criar.conta');
Route::post('auth-login', [AuthController::class, 'auth'])->name('auth.login');
Route::post('auth-senha', [AuthController::class, 'change_password'])->name('auth.senha');
Route::post('auth-criar-conta', [AuthController::class, 'criar_conta_cliente'])->name('auth.criar-conta');
Route::get('esqueceu-sua-senha', [AppController::class, 'forget_password'])->name('esqueceu-senha');
Route::get('recuperar-sua-senha/{email}', [AppController::class, 'recover_password'])->name('recuperar-senha');
Route::post('auth-send-link', [AuthController::class, 'forget_password'])->name('auth.esqueceu-senha');
Route::put('auth-recuperar-senha', [AuthController::class, 'recover_password'])->name('auth.recuperar-senha');
Route::post('candidatura-store', [CandidaturasController::class, 'store'])->name('salvar-candidatura');
Route::middleware('auth')->group(function () {

    Route::prefix('cliente/dashboard')->middleware('cliente')->group(function () {
        Route::get('/', [AppController::class, 'painel_cliente'])->name('painel.cliente');
        Route::get('minhas-candidaturas', [CandidaturasClienteController::class, 'index'])->name('candidaturas-clientes.index');
        Route::delete('minhas-candidaturas', [CandidaturasClienteController::class, 'destroy'])->name('candidaturas-clientes.destroy');

        Route::get('meus-projectos', [ObrasClienteController::class, 'index'])->name('projectos-clientes.index');
    });

    Route::prefix('admin/dashboard')->middleware('admin')->group(function () {
        Route::get('/', [AppController::class, 'painel_admin'])->name('painel.admin');
        // Route::resource('servicos', ServicosController::class);
        Route::resource('vagas', VagasController::class);
        Route::resource('candidaturas', CandidaturasController::class);
        Route::resource('projectos', ProjectosController::class);
        Route::resource('noticias', NoticiasController::class);

        //Restauro do sistema
        Route::post('restauro', [RestauroController::class, 'restore'])->name('restauro.tabelas');
        Route::get('restauro', [RestauroController::class, 'index'])->name('restauro.index');

        //backup
        Route::post('backup', [BackupController::class, 'store'])->name('backup.store');
        Route::get('backup', [BackupController::class, 'index'])->name('backup.index');

        Route::resource('usuarios', UsuariosController::class);
        Route::resource('clientes', ClientesController::class);
        Route::resource('obras', ObrasController::class);

        Route::get('/obras/clientes/buscar', [ObrasController::class, 'buscarClientes'])
        ->name('obras.clientes.buscar');

        //relatório de obras
        Route::post('relatorios/store/{id}', [RelatorioObraController::class, 'storeFiles'])->name('relatorios.store');


    });

    Route::prefix('configuracoes')->group(function (){
            Route::get('perfil', [AppController::class, 'perfil'])->name('perfil');
            Route::post('update-perfil/{id}', [PerfilController::class, 'updatePerfil'])->name('update.perfil');
            Route::post('update-imagem-perfil', [PerfilController::class, 'updateImagem'])->name('update.imagem');
            Route::delete('destroyAccount/{id}', [PerfilController::class, 'destroyAccount'])->name('destroy.perfil');
    });

    Route::get('logout', [AuthController::class, 'logout'])->name('auth.logout');

});
