<?php $__env->startSection('content'); ?>


<section class="page-portfolio header">

    <div class="hero-section d-flex">
            <div class="text-desc ">
                <h1 class="fw-bold">Garantimos qualidade e segurança em nossos projectos</h1>
                <p class="small my-4 text-muted">Lorem ipsum dolor sit amet consectetur, adipisicing elit. Dolorum quos, vero minima fugiat a numquam rerum cum odio aperiam repudiandae distinctio? Quae quaerat cupiditate ipsa excepturi temporibus obcaecati tempore eveniet.</p>
            </div>

           <div class="hero-img ">
                <img src="<?php echo e(asset('assets/img/background11.jpg')); ?>" alt="image-2" width="200">
           </div>
    </div>
</section>

<section class="projects d-flex justify-content-between">
    <form method="GET" action="<?php echo e(route('portfolio')); ?>" class="filters-menu shadow">

        <p class="my-2 fw-bold">Filtros</p>
        <hr>

        
        <div class="item">
            <p class="my-2 fw-bold">Tipo de serviço</p>
            <ul class="list-unstyled text-muted">

                <?php
                    $servicos = [
                        'construcao' => 'Construção',
                        'obras_publicas' => 'Obras públicas',
                        'reforma' => 'Reformas',
                        'projecto_engenharia' => 'Projectos de engenharia',
                        'design_arquitectura' => 'Design de arquitectura',
                        'design_interior' => 'Design de interior'
                    ];
                ?>

                <?php $__currentLoopData = $servicos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $slug => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li>
                        <input
                            type="checkbox"
                            name="servico[]"
                            value="<?php echo e($slug); ?>"
                            id="servico_<?php echo e($slug); ?>"
                            <?php echo e(in_array($slug, request('servico', [])) ? 'checked' : ''); ?>

                        >
                        <label for="servico_<?php echo e($slug); ?>"><?php echo e($label); ?></label>
                    </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </ul>
        </div>

        
        <div class="item">
            <p class="my-2 fw-bold">Tipo de projecto</p>
            <ul class="list-unstyled text-muted">

                <?php
                    $tipos = [
                        'residencial' => 'Residencial',
                        'comercial' => 'Comercial',
                        'industrial' => 'Industrial',
                    ];
                ?>

                <?php $__currentLoopData = $tipos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $slug => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li>
                        <input
                            type="checkbox"
                            name="projecto[]"
                            value="<?php echo e($label); ?>"
                            id="projecto_<?php echo e($slug); ?>"
                            <?php echo e(in_array($slug, request('projecto', [])) ? 'checked' : ''); ?>

                        >
                        <label for="projecto_<?php echo e($slug); ?>"><?php echo e($label); ?></label>
                    </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </ul>

            <button class="btn btn-dark w-100" style="font-size: 14px">
                Filtrar
            </button>
        </div>

    </form>

    <div class="projects-content">
        <div class="search">
            <input type="search" name="" id="" placeholder="Pesquisar alguma coisa">
        </div>

        <div class="card-projects">
            <?php $__currentLoopData = $projectos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $projecto): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <div class="card-projects-item shadow-sm">
                    <div class="image"><img src="<?php echo e(asset('storage/' .$projecto->imagem_projecto)); ?>" width="80" height="80" alt="<?php echo e($projecto->nome_projecto); ?>"></div>
                    <div class="desc">
                        <p class="fw-bold m-0"><?php echo e($projecto->nome_projecto); ?></p>
                        <span class="small text-muted"><i class="bx bx-map"></i> <?php echo e($projecto->endereco); ?></span>
                        <hr>
                        <a class="btn btn-dark" href="<?php echo e(route('project-details', $projecto->projecto_id)); ?>" style="font-size:14px"> ver mais</a>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>

<?php echo $__env->make('components.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\website-van_thanh\resources\views/website/portfolio.blade.php ENDPATH**/ ?>