<!-- Bootstrap Table with Header - Dark -->
<div class="card">
    <div class="card-header">
        <h5>Tabela de vagas</h5>
        <form method="GET" action="<?php echo e(route('vagas.index')); ?>" id="formSearch">
        <div>
            <div class="input-group input-group-merge">
            <span id="basic-icon-default-fullname2" class="input-group-text"
                ><i class="icon-base bx bx-search"></i
            ></span>
                <input
                type="text"
                class="form-control"
                id="search"
                name="search"
                placeholder="Pesquisar"
                value="<?php echo e(request('search')); ?>"
                aria-label="Pesquisar"
                aria-describedby="basic-icon-default-fullname2" />

            </div>
        </div>
        </form>
    </div>
    <div class="table-responsive text-nowrap">
        <table class="table">
            <thead class="table-dark">
                <tr>
                <th>Vaga</th>
                <th>Descrição da vaga</th>
                <th>Data de inicio</th>
                <th>Data de fim</th>
                <th>Acções</th>
                </tr>
            </thead>
            <tbody class="table-border-bottom-0">
                <?php $__currentLoopData = $vagas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vaga): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                    <td>
                        <?php if($vaga->imagem_vaga): ?>
                        <img src="<?php echo e(asset('storage/' . $vaga->imagem_vaga)); ?>" width="50" height="50" class="me-2" style="object-fit: cover; border-radius:50%;">
                        <?php echo e($vaga->nome_vaga); ?>

                        <?php else: ?>
                        <span>Sem imagem - <?php echo e($vaga->nome_vaga); ?> </span>
                        <?php endif; ?>
                    </td>
                    <td title="<?php echo e($vaga->descricao_vaga); ?>"><?php echo e(Str::limit($vaga->descricao_vaga, 50)); ?></td>
                    <td>
                       <?php echo e($vaga->data_inicio); ?>

                    </td>
                    <td><span class="badge bg-label-danger me-1"><?php echo e($vaga->data_fim); ?></span></td>
                    <td>
                        <div class="dropdown">
                        <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                            <i class="icon-base bx bx-dots-vertical-rounded"></i>
                        </button>
                        <div class="dropdown-menu">
                            <a class="dropdown-item" data-bs-toggle="modal" href="#modal-editar-vaga<?php echo e($vaga->vaga_id); ?>"
                            ><i class="icon-base bx bx-edit-alt me-1"></i> Editar</a
                            >
                            <form action="<?php echo e(route('vagas.destroy', $vaga->vaga_id)); ?>" method="post">
                                <?php echo method_field('DELETE'); ?>
                                <?php echo csrf_field(); ?>
                                <button  type="submit" class="dropdown-item"><i class="icon-base bx bx-trash me-1"></i> Deletar</button>

                            </form>
                        </div>
                        </div>
                    </td>
                </tr>
                <?php echo $__env->make('dashboard.admin.pages.vagas._includes.modal-editar-vaga', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </tbody>
        </table>
    </div>
</div>


<!--/ Bootstrap Table with Header Dark -->
<?php /**PATH C:\laragon\www\website-van_thanh\resources\views/dashboard/admin/pages/vagas/_includes/tabela-vagas.blade.php ENDPATH**/ ?>