<!-- Bootstrap Table with Header - Dark -->
<div class="card">
    <div class="card-header">
        <h5>Tabela de obras</h5>
        <form method="GET" action="<?php echo e(route('obras.index')); ?>" id="formSearch">
        <div>
            <div class="input-group input-group-merge">
            <span id="basic-icon-default-fullname2" class="input-group-text"
                ><i class="icon-base bx bx-search"></i
            ></span>
                <input
                type="text"
                class="form-control"
                id="search"
                name="search"
                placeholder="Pesquisar"
                value="<?php echo e(request('search')); ?>"
                aria-label="Pesquisar"
                aria-describedby="basic-icon-default-fullname2" />

            </div>
        </div>
        </form>
    </div>
    <div class="table-responsive text-nowrap">
        <table class="table">
            <thead class="table-dark">
                <tr>
                <th title="">Nome da Obra</th>
                <th>Referência</th>
                <th>Nome do cliente</th>
                <th>Tipo de obra</th>
                <th>Custo Total</th>
                <th>Acções</th>
                </tr>
            </thead>
            <tbody class="table-border-bottom-0">
                <?php if($obras->isEmpty()): ?>
                       <tr>
                            <td colspan="7" class="text-center" style="font-size: 15px;">
                                Nenhum resultado encontrado
                            </td>
                        </tr>
                <?php else: ?>
                    <?php $__currentLoopData = $obras; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $obra): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                        <td> <?php echo e($obra->nome_obra); ?></td>

                        <td><span class="badge bg-label-primary me-1"><?php echo e($obra->ref_obra); ?></span></td>

                        <td>
                            <?php if($obra->cliente_id == null): ?>
                                Não vinculado ainda
                            <?php else: ?>
                                <?php echo e($obra->cliente->nome_cliente); ?>

                            <?php endif; ?>
                        </td>
                        <td><?php echo e($obra->tipo_servico); ?> - <?php echo e($obra->tipo_projecto); ?></td>
                        <td><?php echo e(number_format($obra->custo_total, 2, ',', '.')); ?>

                            <?php if($obra->moeda == "Dolar_americano"): ?> USD <?php elseif($obra->moeda == "Kwanza"): ?> AOA <?php else: ?> EUR <?php endif; ?>
                        </td>
                        <td>
                            <div class="dropdown">
                            <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                <i class="icon-base bx bx-dots-vertical-rounded"></i>
                            </button>
                            <div class="dropdown-menu">
                                <a class="dropdown-item" href="<?php echo e(route('obras.edit', $obra->obra_id)); ?>"
                                ><i class="icon-base bx bx-edit-alt me-1"></i> Edit</a
                                >
                                <a class="dropdown-item" href="#modal_relatorio<?php echo e($obra->obra_id); ?>" data-bs-toggle="modal"
                                ><i class="icon-base bx bx-edit-alt me-1"></i> Relatório</a
                                >
                                <form action="<?php echo e(route('obras.destroy', $obra->obra_id)); ?>" method="post">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="dropdown-item"><i class="icon-base bx bx-trash me-1"></i> Delete</button>
                                </form>
                            </div>
                            </div>
                        </td>
                        </tr>
                        <?php echo $__env->make('dashboard.admin.pages.obras._includes.modal-add-relatorio', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>


            </tbody>
        </table>
    </div>
</div>
<!--/ Bootstrap Table with Header Dark -->
<?php /**PATH C:\laragon\www\website-van_thanh\resources\views/dashboard/admin/pages/obras/_includes/tabela-obras.blade.php ENDPATH**/ ?>